<?php

use Illuminate\Support\Carbon;
use App\Maquinas;

function formatearDosCifras($numero)
{
    // Convertir el número a una cadena y agregar un cero adelante si solo tiene una cifra
    return str_pad($numero, 2, '0', STR_PAD_LEFT);
}

function formatearTiempo($numero)
{
    // Inicializar el arreglo de resultado
    $arreglo = [
        'horas' => 0,
        'minutos' => $numero,
    ];

    // Verificar si el número es mayor o igual a 60
    if ($numero >= 60) {
        // Calcular las horas y minutos
        $arreglo['horas'] = floor($numero / 60);
        $arreglo['minutos'] = $numero % 60;
    }

    $arreglo['horas'] = intval($arreglo['horas']);
    $arreglo['minutos'] = intval($arreglo['minutos']);

    return $arreglo;
}

?>


<?php $__env->startSection('content'); ?>
    


    <div id="contenedor-dashboard" class="container-fluid">
        <div class="row ">
            <div class="col-md-12">
                <h2>Reporte diario de Producción</h2>
            </div>
        </div>
    </div>
    <div id="contenedor-dashboard" class="container-fluid">
        <div class="row ">
            <div class="col-md-3">
                <form method="POST" action="<?php echo e(route('fabricacion.historico_reporte')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="input-group mb-3">
                        <input type="date" name="date" class="form-control rounded-0"
                            value="<?php echo e(\Carbon\Carbon::now()->format('Y-m-d')); ?>">
                        <button class="btn btn-outline-primary rounded-0" type="submit" id="button-addon2">Buscar</button>
                    </div>
                </form>
            </div>
        </div>
        <div class="col">
            <h5>Reporte de: <?php echo e($fechaAyer); ?></b></h5>
        </div>
    </div>
    </div>
    <div class="container-fluid">

        <table class="table table-bordered">
            <thead class="thead-light">
                <tr>
                    <th>Grupo</th>
                    <th>Maquina</th>
                    <th style="width: 30px;">Horas trabajadas</th>
                    <th>Descripción</th>
                    <th style="width: 20px;">Cantidad producida</th>
                    <th style="width: 20px;">Medida</th>
                    <th style="width: 40px;">Rendimiento por hora</th>
                    <th>Observación</th>
                </tr>
            </thead>
            <tbody>
                <?php
                    $grupos = [
                        'CUPS' => ['HQL CUP', 'DRQ- Cups'],
                        'CAPUCHONES' => ['HQL1', 'HQL2', 'HQL3', 'HQL4', 'DRQ- Gr'],
                        'LIENZOS' => ['CONVERTIDORA 1', 'CONVERTIDORA 2'],
                    ];
                    $cantidadTotalGrupos = ['CUPS' => 0, 'CAPUCHONES' => 0, 'LIENZOS' => 0];
                    $reportesAgrupados = ['CUPS' => [], 'CAPUCHONES' => [], 'LIENZOS' => [], 'SIN GRUPO' => []];
                ?>
                <?php $__currentLoopData = $reportes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reporte): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $maquina = Maquinas::find($reporte->id_maquina);
                        $nombreMaquina = $maquina->maquina;
                        $grupo = null;
                        foreach ($grupos as $key => $value) {
                            if (in_array($nombreMaquina, $value)) {
                                $grupo = $key;
                                break;
                            }
                        }
                        if ($grupo === null) {
                            $grupo = 'SIN GRUPO';
                        }
                        if (isset($cantidadTotalGrupos[$grupo])) {
                            $cantidadTotalGrupos[$grupo] += $reporte->total_cantidad;
                        } else {
                            $cantidadTotalGrupos[$grupo] = $reporte->total_cantidad;
                        }
                        $reportesAgrupados[$grupo][] = $reporte;
                    ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <?php $__currentLoopData = $reportesAgrupados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grupo => $reportes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php $__currentLoopData = $reportes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reporte): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $maquina = Maquinas::find($reporte->id_maquina);
                            $nombreMaquina = $maquina->maquina;
                            $rendimientoPorHora = 0;
                            if ($reporte->total_cantidad && $reporte->total_horas != 0) {
                                $rendimientoPorHora = $reporte->total_cantidad / abs($reporte->total_horas);
                            }
                        ?>
                        <tr>
                            <td><?php echo e($grupo); ?></td>
                            <td><?php echo e($nombreMaquina); ?></td>
                            <td>
                                <?php
                                    $resultado = formatearTiempo($reporte->total_minutos);
                                    if ($resultado['horas'] >= 1) {
                                        echo formatearDosCifras($reporte->total_horas + $resultado['horas']);
                                        echo ':';
                                        echo formatearDosCifras($resultado['minutos']);
                                    } else {
                                        echo formatearDosCifras($reporte->total_horas);
                                        echo ':';
                                        echo formatearDosCifras($resultado['minutos']);
                                    }
                                ?>
                            </td>
                            <td><?php echo e($reporte->trabajo); ?></td>
                            <td><?php echo e(number_format($reporte->total_cantidad, 2, '.', ',')); ?></td>
                            <td><?php echo e($reporte->medida); ?></td>
                            <td><?php echo e(number_format($rendimientoPorHora, 2, '.', ',')); ?></td>
                            <td><?php echo e($reporte->observacion); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php if($grupo !== 'SIN GRUPO'): ?>
                        <tr style="background-color: rgb(179, 255, 179);">
                            <td colspan="4">Total <?php echo e($grupo); ?></td> 
                            <td colspan="4"><?php echo e(number_format($cantidadTotalGrupos[$grupo], 2, '.', ',')); ?></td>
                        </tr>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="8">
                        Observaciones:
                        <?php if(count($reportesGeneral) == 0): ?>
                            No hay comentarios generales
                        <?php else: ?>
                            <?php echo e($reportesGeneral[0]->observacion); ?>

                        <?php endif; ?>
                    </td>
                </tr>
            </tfoot>
        </table>


    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('fabricacion.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devpwg5/laravelrp.com/resources/views/fabricacion/historico_maquinaria.blade.php ENDPATH**/ ?>