<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Prueba PDF</title>
    <style>
      @font-face {
        font-family: 'Courier Prime';
        src: url('/laravelrp.com/public/fonts/CourierPrime-Regular.ttf') format('truetype'),
             url('/laravelrp.com/public/fonts/CourierPrime-Bold.ttf') format('truetype'),
             url('/laravelrp.com/public/fonts/CourierPrime-Italic.ttf') format('truetype'),
             url('/laravelrp.com/public/fonts/CourierPrime-BoldItalic.ttf') format('truetype');
        font-weight: normal;
        font-style: normal;
      }

      @font-face {
        font-family: 'Consolas';
        src: url('consolas.ttf') format('truetype');
        font-weight: normal;
        font-style: normal;
      }

      body{
        font-family: 'Courier Prime', monospace!important;
        font-weight: 700;
      }
      .posicion-derecha{
        position: absolute;
        right: 0;
        margin-right: 60px;
      }

      .texto-monospace{
        font-family: 'Consolas', monospace!important;
      }
      #cantidad{
        top: 0;
        margin-top: 75px;
        font-size: 14px;
      }
      #descripcionCotizacion{
        width: 100%;
        margin-top: 110px;
        position: absolute;
        top: 170px;
      }
      #descripcionCotizacion td{
        width: 25%;
        padding-top: 10px;
        font-size: 12px;
      }
      #fecha{
        margin-left: 50px;
        margin-top: 75px;
      }
      #cliente{
        margin-left: 90px; 
        line-height: 10px;
        margin-top: -3px;
      }
      #total{
        margin-left: 100px;
        margin-top: -5px;

      }
      .total_t{
        padding-left: 10px;
      }
      #total2{
        font-weight: 700;
        top: 385px;
        right: 6px;
        font-size: 12px;
      }
      #firma{
        position: absolute;
        top: 412px;
        width: 100%;
        text-align: center;
      }
      #cometario{
        margin-left: 50px;
        margin-top: 50px;
      }
      .columna1{
        padding-left: 20px;
      }
      .columna2,
      .columna3{
        padding-left: 30px;
      }
      .contenido-recibo {
        font-weight: 600;
      }

    </style>

</head>
<body class="texto-monospace">
    <div id="contenido">
      <p id="id_recibo2" class="posicion-derecha texto-monospace"><?php echo e($id_recibo); ?></p>
      <p id="fecha" class="texto-monospace">Guatemala <?php echo e($dia); ?> de <?php echo e($mes); ?> del <?php echo e($ano); ?></p>
      <p id="cantidad" class="posicion-derecha texto-monospace"><?php echo e(number_format($total_f,2,'.',',')); ?></p>
      <p id="cliente" class="texto-monospace"><?php echo e($nombre_cliente); ?></p>
        <p id="total" class="texto-monospace">
        <?php
            require_once ('cotizaciones/NumeroALetras.php');
            $formatter = new NumeroALetras();
            echo $formatter->toMoney($total_f, 2, 'QUETZALES', 'CENTAVOS');
        ?>
        </p>
        <p id="cometario" class="texto-monospace"><?php echo e($observacion??''); ?></p>
        <table id="descripcionCotizacion">
            <tbody>
              <?php $__currentLoopData = $facturas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$factura): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($key); ?></td>
                <td class="columna1 texto-monospace">Q <?php echo e(number_format($factura['cheque'],2,'.',',')); ?></td>
                <td class="columna2 texto-monospace">Q <?php echo e(number_format($factura['efectivo'],2,'.',',')); ?></td>
                <td class="columna3 texto-monospace">Q <?php echo e(number_format($factura['total'],2,'.',',')); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
            </tbody>
        </table>
        <p id="total2" class="posicion-derecha texto-monospace">Q <?php echo e(number_format($total_f,2,'.',',')); ?></p>
        <p id="firma" class="texto-monospace"><?php echo e($nombre_ejecutivo); ?></p>
    </div>
</body>
</html>
<?php /**PATH /home/devpwg5/laravelrp.com/resources/views/contabilidad/imprimir_recibo.blade.php ENDPATH**/ ?>