<?php $__env->startSection('content'); ?>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<div class="container my-4">
    <div class="row ">
        <div class="col-md-12">
            <h2>Reportes Inventario</h2>
        </div>
    </div>

    <hr>


    <?php if(Auth::user()->id != 7 || Auth::user()->id != 9): ?>
    <div>
        <div class="row ">
            <div class="col-md-12">
                <h3>Cargar Archivos</h3>
            </div>
        </div>
        
        <form action="<?php echo e(route('files.upload')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="mb-3">
                <label for="files" class="form-label">Seleccionar Archivos:</label>
                <input type="file" name="files[]" id="files" multiple class="form-control" required>
            </div>
            <div class="row my-2">
                <div class="col-md-6">
                    <label for="year" class="form-label">Año:</label>
                    <select name="year" id="year" class="form-select">
                        <?php $__currentLoopData = range(date('Y'), date('Y') - 4); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($year); ?>"><?php echo e($year); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-6">
                    <label for="month" class="form-label">Mes:</label>
                    <select name="month" id="month" class="form-select">
                        <?php $__currentLoopData = range(1, 12); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($month); ?>"><span
                                class="text-capitalize"><?php echo e(\Carbon\Carbon::create(null, $month)->locale('es')->translatedFormat('F')); ?></span>
                        </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
            <button type="submit" class="btn btn-primary my-2">Cargar Archivos</button>
        </form>
    </div>
    <?php endif; ?>

    <div class="row mt-5">
        <hr>
        <div class="col-md-12">
            <h4>Historial de Archivos Cargados</h4>
        </div>
    </div>


    
    <?php $__currentLoopData = $files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year => $months): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="accordion mb-3" id="accordion-<?php echo e($year); ?>">
        <div class="accordion-item">
            <h2 class="accordion-header" id="heading-<?php echo e($year); ?>">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                    data-bs-target="#collapse-<?php echo e($year); ?>" aria-expanded="false"
                    aria-controls="collapse-<?php echo e($year); ?>">
                    <?php echo e($year); ?>

                </button>
            </h2>
            <div id="collapse-<?php echo e($year); ?>" class="accordion-collapse collapse"
                aria-labelledby="heading-<?php echo e($year); ?>" data-bs-parent="#accordion-<?php echo e($year); ?>">
                <div class="accordion-body">
                    <div class="accordion" id="accordion-months-<?php echo e($year); ?>">
                        <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month => $files): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="accordion-item">
                            <h2 class="accordion-header"
                                id="heading-month-<?php echo e($year); ?>-<?php echo e($month); ?>">
                                <button class="accordion-button collapsed" type="button"
                                    data-bs-toggle="collapse"
                                    data-bs-target="#collapse-month-<?php echo e($year); ?>-<?php echo e($month); ?>"
                                    aria-expanded="false"
                                    aria-controls="collapse-month-<?php echo e($year); ?>-<?php echo e($month); ?>">
                                    <?php echo e(\Carbon\Carbon::create(null, $month)->locale('es')->translatedFormat('F')); ?>

                                </button>
                            </h2>
                            <div id="collapse-month-<?php echo e($year); ?>-<?php echo e($month); ?>"
                                class="accordion-collapse collapse"
                                aria-labelledby="heading-month-<?php echo e($year); ?>-<?php echo e($month); ?>"
                                data-bs-parent="#accordion-months-<?php echo e($year); ?>">
                                <div class="accordion-body">
                                    <ul>
                                        <?php $__currentLoopData = $files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="my-2">
                                            <span class="mx-5"><?php echo e($file->file_name); ?></span>

                                            
                                            <a href="<?php echo e(url($file->file_path)); ?>"
                                                class="btn btn-success btn-sm">
                                                Descargar
                                            </a>

                                            
                                            

                                            
                                            <button type="button" class="btn btn-warning btn-sm"
                                                data-bs-toggle="modal"
                                                data-bs-target="#replaceModal-<?php echo e($file->id); ?>">
                                                Reemplazar
                                            </button>

                                            
                                            <div class="modal fade" id="replaceModal-<?php echo e($file->id); ?>"
                                                tabindex="-1"
                                                aria-labelledby="replaceModalLabel-<?php echo e($file->id); ?>"
                                                aria-hidden="true">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title"
                                                                id="replaceModalLabel-<?php echo e($file->id); ?>">
                                                                Reemplazar archivo: <?php echo e($file->file_name); ?>

                                                            </h5>
                                                            <button type="button" class="btn-close"
                                                                data-bs-dismiss="modal"
                                                                aria-label="Close"></button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <form
                                                                action="<?php echo e(route('files.replace', $file->id)); ?>"
                                                                method="POST"
                                                                enctype="multipart/form-data">
                                                                <?php echo csrf_field(); ?>
                                                                <div class="mb-3">
                                                                    <label for="file-<?php echo e($file->id); ?>"
                                                                        class="form-label">Seleccionar
                                                                        nuevo archivo:</label>
                                                                    <input type="file" name="file"
                                                                        id="file-<?php echo e($file->id); ?>"
                                                                        class="form-control" required>
                                                                </div>
                                                                <button type="submit"
                                                                    class="btn btn-primary">Reemplazar</button>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('inventario.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devpwg5/laravelrp.com/resources/views/inventario/archivo_reporte.blade.php ENDPATH**/ ?>