@extends('layouts.app')
@extends('reportes.menu')

@section('content')
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <div class="container my-4">
        <div class="row mt-5">
            <hr>
            <div class="col-md-12">
                <h4>Historial de Archivos Producto Terminado</h4>
            </div>
        </div>
        {{-- Archivos cargados --}}
        @foreach ($files as $year => $months)
            <div class="accordion mb-3" id="accordion-{{ $year }}">
                <div class="accordion-item">
                    <h2 class="accordion-header" id="heading-{{ $year }}">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapse-{{ $year }}" aria-expanded="false"
                            aria-controls="collapse-{{ $year }}">
                            {{ $year }}
                        </button>
                    </h2>
                    <div id="collapse-{{ $year }}" class="accordion-collapse collapse"
                        aria-labelledby="heading-{{ $year }}" data-bs-parent="#accordion-{{ $year }}">
                        <div class="accordion-body">
                            <div class="accordion" id="accordion-months-{{ $year }}">
                                @foreach ($months as $month => $files)
                                    <div class="accordion-item">
                                        <h2 class="accordion-header"
                                            id="heading-month-{{ $year }}-{{ $month }}">
                                            <button class="accordion-button collapsed" type="button"
                                                data-bs-toggle="collapse"
                                                data-bs-target="#collapse-month-{{ $year }}-{{ $month }}"
                                                aria-expanded="false"
                                                aria-controls="collapse-month-{{ $year }}-{{ $month }}">
                                                {{ \Carbon\Carbon::create(null, $month)->locale('es')->translatedFormat('F') }}
                                            </button>
                                        </h2>
                                        <div id="collapse-month-{{ $year }}-{{ $month }}"
                                            class="accordion-collapse collapse"
                                            aria-labelledby="heading-month-{{ $year }}-{{ $month }}"
                                            data-bs-parent="#accordion-months-{{ $year }}">
                                            <div class="accordion-body">
                                                <ul>
                                                    @foreach ($files as $file)
                                                        <li class="my-2">
                                                            <span class="mx-5">{{ $file->file_name }}</span>

                                                            {{-- Botón para descargar --}}
                                                            <a href="{{ url($file->file_path) }}"
                                                                class="btn btn-success btn-sm">
                                                                Descargar
                                                            </a>
                                                        </li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
@endsection
