@extends('layouts.app')
@extends('reportes.menu')
@section('content')
    <style>

        .form-check {
            display: inline-block;
            top: -15px;
            left: 13px;
        }
        .colorAmarillo{
            background-color: #ffc107!important;
            font-weight: 600;
        }
        .colorAmarillo .sorting_1{
            background-color: #ffc107!important;
            font-weight: 600;
        }

        #mobile-indicator {
            display: block;
        }

        @media (max-width: 767px) {
            #mobile-indicator {
                display: none;
            }
        }
    </style>



        @csrf
        <div id="contenedor-dashboard" class="container-fluid">
            <div class="row ">
                <div class="col-md-12">
                    <h2>Resumen del Año - Recibos de Caja</h2>
                </div>
            </div>
            <div class="col-md-12">
                    {{-- Contenedor primario para botones y formularios--}}
                <table id="example2" class="display" style="width:100%">
                    <thead>
                        <tr>
                            <td>Fecha</td>
                            <td>Enero</td>
                            <td>Febrero</td>
                            <td>Marzo</td>
                            <td>Abril</td>
                            <td>Mayo</td>
                            <td>Junio</td>
                            <td>Julio</td>
                            <td>Agosto</td>
                            <td>Septiembre</td>
                            <td>Octubre</td>
                            <td>Noviembre</td>
                            <td>Diciembre</td>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $total=0;?>
                        @foreach ($recibos as $op)
                            <tr>
                                <td> {{ date('d/m/Y', strtotime($op->created_at)) }}</td>
                                <td>Q {{ number_format($op->total_sales, 2, '.', ',') }}</td>
                                <td>Q {{ number_format($op->total_sales, 2, '.', ',') }}</td>
                                <td>Q {{ number_format($op->total_sales, 2, '.', ',') }}</td>
                                <td>Q {{ number_format($op->total_sales, 2, '.', ',') }}</td>
                                <td>Q {{ number_format($op->total_sales, 2, '.', ',') }}</td>
                                <td>Q {{ number_format($op->total_sales, 2, '.', ',') }}</td>
                                <td>Q {{ number_format($op->total_sales, 2, '.', ',') }}</td>
                                <td>Q {{ number_format($op->total_sales, 2, '.', ',') }}</td>
                                <td>Q {{ number_format($op->total_sales, 2, '.', ',') }}</td>
                                <td>Q {{ number_format($op->total_sales, 2, '.', ',') }}</td>
                                <td>Q {{ number_format($op->total_sales, 2, '.', ',') }}</td>
                                <td>Q {{ number_format($op->total_sales, 2, '.', ',') }}</td>
                                <?php $total=$total+$op->total_sales;?>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr class="colorAmarillo">
                            <td>TOTAL</td>
                            <td>Q{{ number_format($total,2,'.',',')}} </td>
                            <td>Q{{ number_format($total,2,'.',',')}} </td>
                            <td>Q{{ number_format($total,2,'.',',')}} </td>
                            <td>Q{{ number_format($total,2,'.',',')}} </td>
                            <td>Q{{ number_format($total,2,'.',',')}} </td>
                            <td>Q{{ number_format($total,2,'.',',')}} </td>
                            <td>Q{{ number_format($total,2,'.',',')}} </td>
                            <td>Q{{ number_format($total,2,'.',',')}} </td>
                            <td>Q{{ number_format($total,2,'.',',')}} </td>
                            <td>Q{{ number_format($total,2,'.',',')}} </td>
                            <td>Q{{ number_format($total,2,'.',',')}} </td>
                            <td>Q{{ number_format($total,2,'.',',')}} </td>
                            <td>Q{{ number_format($total,2,'.',',')}} </td>
                        </tr>
                    </tfoot>
                </table>
    </div>
    </div>
    <script>
        jQuery.fn.dataTable.Api.register( 'sum()', function ( ) {
    return this.flatten().reduce( function ( a, b ) {
        if ( typeof a === 'string' ) {
            a = a.replace(/[^\d.-]/g, '') * 1;
        }
        if ( typeof b === 'string' ) {
            b = b.replace(/[^\d.-]/g, '') * 1;
        }
 
        return a + b;
    }, 0 );
  } );
         $('#example2').DataTable({
            "order":[[ 0, "asc" ]],
            "paging": false,
            "bFilter": false,
            dom: 'Bfrtip',
            buttons: [
                'excel', 'print'
            ],

            responsive:{
                breakpoints: [
                    { name: 'desktop', width: 920 },
                    { name: 'tablet',  width: 768 },
                    { name: 'fablet',  width: 668},
                    { name: 'phone',   width: 480 }
                ]
            },
            drawCallback: function () {
                var api = this.api();

                let dollarUSLocale = Intl.NumberFormat('en-IN');
                $( "#data1" ).html(
                    api.column( 5, {page:'current'} ).data().sum().toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')
                );
                
            }
            
        });
        $('.revertir_recibo').click(function(){
            var confirmar= confirm("Esta seguro de querer revertir la operación");
            if(confirmar){

            }else{
                return false;
            }
        })
        $("#fechaInicio").datepicker();
        $("#fechaFin").datepicker();


        function isMobileWidth() {
            return $('#mobile-indicator').is(':visible');
        }

    </script>
@endsection
