@extends('layouts.app')

@section('content')
    @extends('contabilidad.menu')
    <form action="{{ route('contabilidad.guardar_recibo_caja_editado') }}" method="POST"
        onkeydown="return event.key != 'Enter';" enctype="multipart/form-data" id="formEnviar">
        @csrf
        <div id="contenedor_interno" class="container-fluid">
            <div class="row ">
                <div class="col-md-12">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('contabilidad.dashboard_recibos') }}">Recibo de
                                    caja</a></li>
                            <li class="breadcrumb-item active" aria-current="page">Editar</li>
                        </ol>
                    </nav>
                    <button class="botonColor" id="botonEnviar">Guardar cambio Recibo de Caja</button>
                </div>
                <hr>
            </div>
        </div>

        <div id="contenedor_contenido" class="container-fluid px-lg-5">
            <div class="row">
                <div class="col-md-12">
                    <h2>Recibo de Caja</h2>
                </div>
                <div class="col-md-12">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Cliente</label>
                                <div class="col-sm-8">
                                    <p>{{ $recibo->cliente->nombre }}</p>
                                    <input type="hidden" name="id_recibo_editar" value="{{ $recibo->id }}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Nit</label>
                                <div class="col-sm-8">
                                    <input type="text" readonly class="form-control-plaintext" id="nit"
                                        value="{{ $recibo->cliente->nit }}" placeholder="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Dirección</label>
                                <div class="col-sm-8">
                                    <p>{{ $recibo->cliente->direccion }}</p>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Moneda</label>
                                <div class="col-sm-8">
                                    <select class="form-control" name="id_moneda" id="exampleFormControlSelect1">
                                        <option {{ $recibo->cliente->id_moneda == 1 ? 'selected' : '' }} value="1">Q
                                        </option>
                                        <option {{ $recibo->cliente->id_moneda == 2 ? 'selected' : '' }} value="2">$
                                        </option>
                                    </select>
                                </div>
                            </div>
                        </div>


                        <div class="col-md-6">

                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Condiciones de pago</label>
                                <div class="col-sm-8">
                                    @if ($recibo->cliente->condiciones_pago == 1)
                                        <p>Contado</p>
                                    @endif
                                    @if ($recibo->cliente->condiciones_pago == 6)
                                        <p>8 días</p>
                                    @endif
                                    @if ($recibo->cliente->condiciones_pago == 2)
                                        <p>15 días</p>
                                    @endif
                                    @if ($recibo->cliente->condiciones_pago == 3)
                                        <p>30 días</p>
                                    @endif
                                    @if ($recibo->cliente->condiciones_pago == 4)
                                        <p>45 días</p>
                                    @endif
                                    @if ($recibo->cliente->condiciones_pago == 5)
                                        <p>60 días</p>
                                    @endif
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Régimen fiscal
                                </label>
                                <div class="col-sm-8">
                                    @if ($recibo->cliente->tipo_regimen == 1)
                                        <p>Ninguno</p>
                                    @endif
                                    @if ($recibo->cliente->tipo_regimen == 2)
                                        <p>Decreto régimen 2989</p>
                                    @endif
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Número Recibo Caja</label>
                                <div class="col-sm-8">
                                    <input type="number" name="numero_recibo_caja" class="form-control-plaintext"
                                        value="{{ $recibo->recibo_caja_numero }}" placeholder="" required>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Imagen Recibo de caja</label>
                                <div class="col-sm-8">
                                    <input type="file" name="imagen_recibo" class="form-control-plaintext"
                                        accept="image/png, image/gif, image/jpeg">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Concepto del recibo*</label>
                                <div class="col-sm-8">
                                    <input type="text" name="observacion_rc" class="form-control-plaintext"
                                        value="{{ $recibo->observacion ?? '' }}" placeholder="" required>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Productos -->
                    <div class="row">
                        <div class="col-md-12">
                            <ul class="nav nav-tabs" id="myTab">
                                <li class="nav-item">
                                    <a href="#home" class="nav-link" data-toggle="tab">Lista del pedido</a>
                                </li>
                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane fade" id="home">
                                    <table id="table_recibo" class="table">
                                        <thead>
                                            <tr>
                                                <th scope="col">ID</th>
                                                <th scope="col">Factura</th>
                                                <th scope="col">Saldo</th>
                                                <th scope="col">Cheque No / Retención</th>
                                                <th scope="col">Cheque Q</th>
                                                <th scope="col">Efectivo</th>
                                                <th scope="col">Valor Retención</th>
                                                <th scope="col">Total</th>
                                            </tr>
                                        </thead>
                                        <tbody id="contenedorProductos">
                                            @foreach ($recibo->facturas as $factura)
                                                @if ($factura->id_factura)
                                                    <tr class="items_recibo_caja">
                                                        <input type="hidden" name="id_recibo[]"
                                                            value="{{ $factura->id }}">
                                                        <input type="hidden" name="total_factura[]"
                                                            value="{{ $factura->abono }}">
                                                        <td>
                                                            <p>{{ $factura->id }}</p>
                                                        </td>
                                                        @if ($factura->ver_factura->no_sat ?? false)
                                                            <td>
                                                                <p>{{ $factura->ver_factura->no_sat ?? '' }} - <a
                                                                        href="{{ asset('/facturas/' . $factura->ver_factura->archivo_factura ?? '') }}"
                                                                        target='_blank'><i class="fas fa-camera"></i></a>
                                                                </p>
                                                            </td>
                                                        @else
                                                            <td>
                                                                <p>{{ $factura->ver_factura->no_sat ?? '' }} - </p>
                                                            </td>
                                                        @endif

                                                        <td>
                                                            <p>{{ number_format($factura->abono, 2, '.', ',') }}</p>
                                                        </td>
                                                        <td><input type="text" name="cheques[]"
                                                                value="{{ $factura->numero_cheque }}"></td>
                                                        <td><input type="" onchange="calcularSubTotal2(this)"
                                                                class="cheque" name="cheque_q[]"
                                                                value="{{ $factura->cheque_q }}"></td>
                                                        <td><input type="" onchange="calcularSubTotal2(this)"
                                                                class="efectivo" name="efectivo[]"
                                                                value="{{ $factura->efectivo }}"></td>
                                                        <td><input type="" onchange="calcularSubTotal2(this)"
                                                                class="retencion" name="retencion[]"
                                                                value="{{ $factura->retencion }}"></td>
                                                        <td class="total"><input type="tex" class="total_factura"
                                                                name="total[]" step="any" readonly
                                                                value="{{ $factura->efectivo + $factura->retencion + $factura->cheque_q }}">
                                                        </td>
                                                    </tr>
                                                @endif
                                            @endforeach
                                        </tbody>
                                    </table>
                                    <hr>
                                    <div class="total">
                                        <p>TOTAL: Q <input id="totalTotal" name="total_total" type="text" readonly
                                                value="{{ $recibo->id_total }}"></p>
                                    </div>

                                </div>

                            </div>
                        </div>


                    </div>
                </div>
            </div>
    </form>
    <script>
        function calcularSubTotal2(elemento) {
            var padre = elemento.parentElement.parentElement;
            var cheque = parseFloat($(padre).find('.cheque').val()) || 0;
            var efectivo = parseFloat(padre.getElementsByClassName('efectivo')[0].value) || 0;
            var retencion = parseFloat($(padre).find('.retencion').val()) || 0;

            // Convert to cents to avoid floating point errors
            var chequeInt = Math.round(cheque * 100);
            var efectivoInt = Math.round(efectivo * 100);
            var retencionInt = Math.round(retencion * 100);
            var totalTotalInt = chequeInt + efectivoInt + retencionInt;
            var totalTotal = totalTotalInt / 100;

            padre.getElementsByClassName('total_factura')[0].value = totalTotal.toFixed(2);

            var total = 0;
            $('.total_factura').each(function() {
                var value = parseFloat($(this).val()) || 0;
                total = Math.round((total + value) * 100) / 100;
            })
            document.getElementById('totalTotal').value = total.toFixed(2);
        }

        $("#formEnviar").submit(function(event) {
            document.getElementById('botonEnviar').disabled = true;
        });
    </script>
@endsection
