<nav id="menu_interno" class="navbar navbar-expand-lg menu-response">

    <a class="navbar-brand regresarDashboard" href="<?php echo e(route('home')); ?>"><i class="fas fa-border-all"></i></a>
    <a class="navbar-brand" href="<?php echo e(route('contabilidad.dashboard')); ?>">Contabilidad</a>
    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent"
        aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
    </button>


    <div class="collapse navbar-collapse menu-ver" id="navbarSupportedContent">
        <ul class="navbar-nav mr-auto">
            <?php
                // Definir los permisos para el módulo de contabilidad
                $permisosContabilidad = [
                    'despacho_realizado' => [1, 4, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22],
                    'pendientes_facturar' => [1, 4, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22],
                    'facturas' => [1, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22],
                    'facturas_canceladas' => [1, 4, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22],
                    'cuenta_corriente' => [1, 4, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22],
                    'recibos_caja' => [1, 4, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22],
                    'retenciones' => [1, 4, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22],
                    'notas_credito_debito' => [4, 7, 12, 18, 22],
                    'historial_facturas' => [1, 4, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22],
                    'reportes' => [4, 7, 12, 18],
                ];

                // Función para verificar si el usuario tiene acceso
                function tienePermisoContabilidad($idUsuario, $modulo, $permisos)
                {
                    return in_array($idUsuario, $permisos[$modulo]);
                }

                // ID del usuario actual
                $idUsuario = Auth::user()->id;
            ?>

            <?php if(tienePermisoContabilidad($idUsuario, 'despacho_realizado', $permisosContabilidad)): ?>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('contabilidad.dashboard')); ?>">Despacho realizado</a>
                </li>
            <?php endif; ?>

            <?php if(tienePermisoContabilidad($idUsuario, 'pendientes_facturar', $permisosContabilidad)): ?>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('contabilidad.dashboard_solicitud_factura')); ?>">Pendientes
                        Facturar</a>
                </li>
            <?php endif; ?>

            <?php if(tienePermisoContabilidad($idUsuario, 'facturas', $permisosContabilidad)): ?>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('contabilidad.dashboard_facturas')); ?>">Facturas</a>
                </li>
            <?php endif; ?>

            <?php if(tienePermisoContabilidad($idUsuario, 'facturas_canceladas', $permisosContabilidad)): ?>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('contabilidad.dashboard_facturas_canceladas')); ?>">Facturas
                        Canceladas</a>
                </li>
            <?php endif; ?>

            <?php if(tienePermisoContabilidad($idUsuario, 'cuenta_corriente', $permisosContabilidad)): ?>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('contabilidad.dashboard_cuenta_corriente')); ?>">Cuenta
                        Corriente</a>
                </li>
            <?php endif; ?>

            <?php if(tienePermisoContabilidad($idUsuario, 'recibos_caja', $permisosContabilidad)): ?>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('contabilidad.dashboard_recibos')); ?>">Recibos de Caja</a>
                </li>
            <?php endif; ?>

            <?php if(tienePermisoContabilidad($idUsuario, 'retenciones', $permisosContabilidad)): ?>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('contabilidad.dashboard_retenciones')); ?>">Retenciones</a>
                </li>
            <?php endif; ?>

            <?php if(tienePermisoContabilidad($idUsuario, 'notas_credito_debito', $permisosContabilidad)): ?>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('contabilidad.dashboard_notas_credito_debito')); ?>">Notas de
                        Crédito/Débito</a>
                </li>
            <?php endif; ?>

            <?php if(tienePermisoContabilidad($idUsuario, 'historial_facturas', $permisosContabilidad)): ?>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('contabilidad.dashboard_historial_facturas')); ?>">Historial
                        Factura</a>
                </li>
            <?php endif; ?>

            <?php if(tienePermisoContabilidad($idUsuario, 'reportes', $permisosContabilidad)): ?>
                <li class="nav-item dropdown">
                    <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button"
                        data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                        Reportes
                    </a>

                    <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">
                        <a class="dropdown-item" href="<?php echo e(route('contabilidad.reporte_ventas')); ?>">
                            Reporte de ventas por factura
                        </a>
                        <a class="dropdown-item" href="<?php echo e(route('reportes.dashboard')); ?>">
                            Reporte por facturas
                        </a>
                        <a class="dropdown-item" href="<?php echo e(route('reportes.libro_ventas')); ?>">
                            Libro de ventas
                        </a>
                        <a class="dropdown-item" href="<?php echo e(route('reportes.dashboard_recibos_diario')); ?>">
                            Reporte de recibos diario
                        </a>
                        <a class="dropdown-item" href="<?php echo e(route('reportes.dashboard_recibos_mes')); ?>">
                            Reporte de recibos Mes
                        </a>
                        <a class="dropdown-item" href="<?php echo e(route('reportes.dashboard_recibos_anio')); ?>">
                            Reporte resumen de recibos año
                        </a>
                    </div>
                </li>
            <?php endif; ?>
        </ul>
        <ul class="menu-no navbar-nav ml-auto">
            <li class="nav-item dropdown">
                <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button"
                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                    <?php echo e(Auth::user()->name); ?>

                </a>

                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">
                    <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                        onclick="event.preventDefault();
                  document.getElementById('logout-form').submit();">
                        Cerrar sesión
                    </a>

                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                        <?php echo csrf_field(); ?>
                    </form>
                </div>
            </li>
        </ul>
    </div>
</nav>
<?php /**PATH /home/devpwg5/laravelrp.com/resources/views/contabilidad/menu.blade.php ENDPATH**/ ?>