<?php $__env->startSection('content'); ?>
    <style>
        .import-success {
            background-color: red !important;
            border-radius: 5px;
        }

        .import-success a {
            color: white !important;
        }
    </style>
    <div id="contenedor-dashboard" class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <a type="button" href="<?php echo e(route('compras.locales.nueva')); ?>" class="botonColor">NUEVA</a>
            </div>
        </div>

        <div class="col-md-12" style="margin-top: 150px !important;">
            <br>
            <table id="compras-table" class="display" style="width:100%">
                <thead>
                    <tr>
                        <th scope="col">Referencia</th>
                        <th scope="col">Proveedor</th>
                        <th scope="col">Producto</th>
                        <th scope="col">Documento</th>
                        <th scope="col">Valor</th>
                        <th scope="col">Condiciones Pago</th>
                        <th scope="col">Credito</th>
                        <th scope="col">Observacion</th>
                        <th scope="col">Fecha Creacion</th>
                        <th scope="col">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    
                    <?php $__currentLoopData = $compras; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $compra): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr style="height: 60px !important;">
                            <td class="<?php echo e($compra->estado == 3 ? 'import-success' : ''); ?>">
                                <!-- <a href="<?php echo e(route('compras.locales.detalle', $compra->id)); ?>">OC-<?php echo e($compra->id); ?> <?php echo e($compra->estado == 3 ? ' revisado' : ''); ?></a> -->
                                <span>
                                    OC <?php echo e($compra->correlativo); ?> <?php echo e($compra->estado == 3 ? ' revisado' : ''); ?>

                                </span>
                            </td>
                            <td>
                                <?php echo e($compra->proveedor->nombre ?? ''); ?>

                            </td>
                            <td>
                                <ul>
                                    <?php $__currentLoopData = $compra->detalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detalle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $nombre_producto = $detalle->producto
                                                ? $detalle->producto->nombre
                                                : $detalle->descripcion;
                                        ?>
                                        <li>
                                            <?php echo e($nombre_producto); ?>

                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>

                            </td>
                            <td>
                                <a href="<?php echo e(route('compras.locales.descargar', $compra->id)); ?>" target="_blank"
                                    rel="noopener noreferrer">Descargar Orden</a>
                            </td>
                            <td>
                                <?php echo e($compra->moneda_simbolo); ?>.<?php echo e(number_format($compra->total_factura, 2, '.', ',')); ?>

                            </td>
                            <td><?php echo e($compra->condiciones_pago); ?></td>
                            <td><?php echo e($compra->condiciones); ?></td>
                            <td><?php echo e($compra->observaciones); ?></td>
                            <td><?php echo e($compra->created_at->format('d/m/Y')); ?></td>
                            <td>
                                <button type="button" class="btn btn-primary btn-sm" data-toggle="modal"
                                    data-target="#uploadModal" data-id="<?php echo e($compra->id); ?>">
                                    Cargar Cotización
                                </button>

                                <?php if($compra->proforma_documento): ?>
                                    <a href="<?php echo e(asset('storage/compras/locales/' . $compra->proforma_documento)); ?>"
                                        target="_blank" class="btn btn-success btn-sm mt-2">
                                        Ver Cotización
                                    </a>
                                <?php endif; ?>
                            </td>

                        </tr>
                        
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                <tfoot>
                    <tr>
                        <th scope="col">Referencia</th>
                        <th scope="col">Proveedor</th>
                        <th scope="col">Producto</th>
                        <th scope="col">Documento</th>
                        <th scope="col">Valor</th>
                        <th scope="col">Condiciones Pago</th>
                        <th scope="col">Credito</th>
                        <th scope="col">Observacion</th>
                        <th scope="col">Fecha Creacion</th>
                        <th scope="col">Acciones</th>
                    </tr>
                    
                </tfoot>
            </table>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="uploadModal" tabindex="-1" role="dialog" aria-labelledby="uploadModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="uploadModalLabel">Cargar Cotización</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="uploadForm" action="" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <input type="hidden" name="compra_id" id="compraId">
                        <div class="form-group">
                            <label for="proforma_documento">Seleccionar Archivo</label>
                            <input type="file" name="proforma_documento" id="proforma_documento" accept="application/pdf"
                                class="form-control" required>
                            <small class="form-text text-muted" id="fileName">No seleccionado</small>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Subir Archivo</button>
                    </div>
                </form>
            </div>
        </div>
    </div>



    <script>
        $(document).ready(function() {
            $.fn.dataTable.moment('DD/MM/YYYY');
            $('#compras-table').dataTable({
                "paging": false,
                "order": [
                    [0, "desc"]
                ],
                dom: 'Bfrtip',
                buttons: [
                    'excel', 'print'
                ]
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            $('#uploadModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var compraId = button.data('id');
                var form = $('#uploadForm');

                // Actualiza la acción del formulario dinámicamente
                form.attr('action', '/public/compras/locales/upload/' + compraId);
                $('#compraId').val(compraId);
            });

            // Mostrar el nombre del archivo seleccionado
            $('#proforma_documento').on('change', function() {
                var fileName = this.files.length > 0 ? this.files[0].name : "No seleccionado";
                $('#fileName').text(fileName);
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('compras.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devpwg5/laravelrp.com/resources/views/compras/locales/dashboard.blade.php ENDPATH**/ ?>