<?php $__env->startSection('content'); ?>
    <style>
        .text-truncate {
            white-space: nowrap;
            /* Evita saltos de línea */
            overflow: hidden;
            /* Oculta el desbordamiento de texto */
            text-overflow: ellipsis;
            /* Agrega "..." cuando el texto es muy largo */
            max-width: 150px;
            /* Ajusta según lo necesario */
        }
    </style>
    <div id="contenedor_contenido" class="container-fluid px-lg-5">
        <hr>
        <div class="row">
            <div class="col-md-12">
                <h2>Importacion: <span><?php echo e($compra->correlativo); ?></span></h2>
            </div>
        </div>
        <?php
            $documento = $compra->estado == 1 ? 'PI' : 'Factura';
            $total_compra = $compra->estado == 1 ? $compra->total_pi : $compra->total_factura;

            function safeDivide($dividendo, $divisor): float
            {
                return $dividendo / ($divisor != 0 ? $divisor : 1);
            }
        ?>
        <?php if($prorrateo_datos): ?>
            <div class="row my-2">
                <div class="col-md-12">
                    <div class="my-4 border border border-success rounded-lg p-3" id="desgloce-prorrateo">
                        <h3>Items Compra</h3>
                        <table class="table table-striped" id="prorrateo-table">
                            <thead>
                                <tr style="height: 62px;">
                                    <th scope="col">Importacion: <span
                                            style="font-weight: 600;"><?php echo e($compra->correlativo ?? 0); ?></span></th>
                                    <th scope="col">Descripcion</th>
                                    <th scope="col">QTY</th>
                                    <th scope="col">Costo Unitario en Dolares</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $total_cantidad_producto = 0;
                                    $total_subtotal = 0;
                                    $total_flete_seguro = 0;
                                    $total_factura = 0;
                                    $total_factura_quetzales = 0;
                                    $total_prorrateo1 = 0;
                                    $total_prorrateo2 = 0;
                                    $total_dai = 0;
                                    $total_valor_mas_dai = 0;
                                ?>
                                <?php $__currentLoopData = $compra->detalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $producto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        // Calculos
                                        $total_cantidad_producto += $producto->cantidad;
                                        $subtotal = $producto->precio * $producto->cantidad;
                                        $total_subtotal += $subtotal;

                                        $coeficiente_flete_seguro = safeDivide(
                                            $compra->total_flete_seguro,
                                            $compra->total_factura,
                                        );
                                        $flete_seguro = $coeficiente_flete_seguro * $subtotal;
                                        $total_flete_seguro += $flete_seguro;

                                        $total_factura_producto = $subtotal + $flete_seguro;
                                        $total_factura += $total_factura_producto;

                                        $total_factura_producto_quetzales =
                                            $total_factura_producto * $compra->tipo_cambio;
                                        $total_factura_quetzales += $total_factura_producto_quetzales;

                                        $prorrateo1 =
                                            $total_factura_producto_quetzales * $prorrateo_datos->coeficiente1 ?? 0;
                                        $total_prorrateo1 += $prorrateo1;

                                        $prorrateo2 =
                                            $total_factura_producto_quetzales * $prorrateo_datos->coeficiente2 ?? 0;
                                        $total_prorrateo2 += $prorrateo2;

                                        $dai_producto = safeDivide(
                                            $prorrateo_datos->total_dai_quetzales,
                                            $compra->detalle->count(),
                                        );
                                        $total_dai += $dai_producto;

                                        $valor_mas_dai =
                                            $total_factura_producto_quetzales +
                                            $dai_producto +
                                            $total_factura_producto_quetzales * $prorrateo_datos->coeficiente1 +
                                            $total_factura_producto_quetzales * $prorrateo_datos->coeficiente2;
                                        $total_valor_mas_dai += $valor_mas_dai;

                                        $costo_unitario = safeDivide($valor_mas_dai, $producto->cantidad);
                                    ?>
                                    <tr>
                                        <td><?php echo e($producto->id); ?></td>
                                        <td><?php echo e($producto->producto->nombre); ?></td>
                                        <td> <?php echo e($producto->cantidad); ?></td>
                                        <td>
                                            $<?php echo e(number_format(safeDivide($costo_unitario, $compra->tipo_cambio), 3, '.', ',')); ?>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <link href="<?php echo e(asset('js/jquery_ui/jquery-ui.css')); ?>" rel="stylesheet">
    <script src="<?php echo e(asset('js/jquery_ui/jquery-ui.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            $('#prorrateo-table').dataTable({
                "paging": false,
                "order": [
                    [0, "asc"]
                ],
                "scrollY": "50vh",
                "scrollX": true,
                "autoWidth": false,
                dom: 'Bfrtip',
                buttons: ['excel', 'print']
            });


            $('#eta').datepicker({
                dateFormat: 'dd/mm/yy'
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('reportes.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devpwg5/laravelrp.com/resources/views/reportes/gerencia/compras/importaciones-detalle.blade.php ENDPATH**/ ?>