@extends('layouts.app')

@section('content')
@extends('ventas.menu')

<div id="contenedor-dashboard" class="container-fluid">
    <div class="row ">
      <div class="col-md-12">
        <h2>Unidades de medidas</h2>
        <a type="button" href="{{route('ventas.productos_medidas_nuevo')}}" class="botonColor">Nuevo</a>
      </div>
    </div>
    <div class="col-md-12">
      <br>
      <br>
      <table id="example" class="display" style="width:100%">
          <thead>
            <tr>
              <td>id</td>
              <td>Nombre</td>
              <td>Acciones</td>
            </tr>
          </thead>
          <tbody>
            @foreach ($medidas as $medida)
                <td>{{$medida->id}}</td>
                <td>{{$medida->nombre}}</td>
                <td><a href="{{route('ventas.productos_medidas_eliminar',$medida->id)}}"><i class="fas fa-trash-alt"></i></a></td>
              </tr>
            @endforeach
          </tbody>
      </table>
    </div>
</div>
<script>
  function archivar(){
    document.querySelectorAll('.form-check-input').forEach(element => {
      var padre=element.parentElement.parentElement.parentElement;
      var idCotizacionProducto=padre.getAttribute('data-id');
      if(element.checked ){
        jQuery( document ).ready(function() {
          var token = '{{ csrf_token() }}';
          $.ajax({
            type:'POST',
            url:'{{ route('ventas.archivar_cotizacion') }}',
            headers: {'X-CSRF-TOKEN': token},
            data:{
              idCotizacionProducto:idCotizacionProducto,
            },
            success:function(data){
              if(data){
                padre.remove();
                Swal.fire({
                    position: 'top-end',
                    title: "Cotización archivada",
                    showConfirmButton: false,
                    timer: 1500
                });
              }
            }
          });
        });
      }
    });
  }
  function produccion(){
    document.querySelectorAll('.form-check-input').forEach(element => {
      var padre=element.parentElement.parentElement.parentElement;
      var idCotizacionProducto=padre.getAttribute('data-id');
      if(element.checked ){
        jQuery( document ).ready(function() {
          var token = '{{ csrf_token() }}';
          $.ajax({
            type:'POST',
            url:'{{ route('ventas.cotizacion_produccion') }}',
            headers: {'X-CSRF-TOKEN': token},
            data:{
              idCotizacionProducto:idCotizacionProducto,
            },
            success:function(data){
              if(data){
                padre.remove();
                Swal.fire({
                    position: 'top-end',
                    title: "Cotización enviada aprobación de producción",
                    showConfirmButton: false,
                    timer: 1500
                });
              }
            }
          });
        });
      }
    });
  }
</script>
@endsection
