@extends('layouts.app')
@extends('contabilidad.menu')

@section('content')
<style>
  .form-check{
    display: inline-block;
    top: -15px;
    left: 13px;
  }
  .verTotal22{
    text-align: right;
    margin-right: 400px;
    font-size: 17px;
    font-weight: 700;
  }
  .regresar{
    margin-top: -10px;
    padding-left: 6px;
  }
  .eliminar{
    margin-top: -10px;
    padding-left: 6px;
  }
  .nota_{
    margin-top: -10px;
    padding-left: 6px;
  }

  .fa-upload {
    padding-top: 5px;
    padding-left: 6px;
  }
</style>
<div class="container date-consult">
  <div class="row">
      <div class="md-col-4 my-4">
        <form action="{{ route('contabilidad.reporte_ventas') }}" method="POST">
              @csrf
              <div class="d-flex flex-column justify-content-center">
                  <div class="d-flex justify-content-center align-items-center">
                      <p class="font-weight-bolder text-uppercase">Fecha Inicio: <input class="date-picker"
                              type="date" name="fechaInicio" id="datepicker"></p>
                      <p class="font-weight-bolder text-uppercase">Fecha Final: <input class="date-picker"
                              type="date" name="fechaFin" id="datepicker2"></p>
                  </div>
                  <div class="d-flex">
                    
                          <div class="d-flex justify-content-center align-items-center">
                              <div>
                                <button type="submit" class="btn btn-dark mx-auto">Consultar</button>
                              </div>
                              @if (isset($salidasAlmacen->fechaInicio))
                              <div class="d-flex">
                                <p class="blockquote mx-2">Fecha consultada</p>
                                <p class="blockquote"> del  <strong>{{ $salidasAlmacen->fechaInicio }}  </strong></p>
                                <p class="blockquote">- al -<strong>{{ $salidasAlmacen->fechaFin }} </strong></p>
                              </div>
                              @endif
                          </div>
                  </div>
                  
              </div>
          </form>
      </div>
  </div>
</div>
<form action="{{ route('contabilidad.recibo_caja_facturas') }}" method="POST">
  @csrf
<div id="contenedor-dashboard" class="container-fluid">
  <div class="row ">
    <div class="col-md-12">
      <h2>Reporte de Ventas por Facturas</h2>
      <div style="margin-top: 100px;"></div>

    </div>
  </div>
  <div class="col-md-12">
    <br>

    <table id="exampleReporte" class="display" style="width:100%">
      <thead>
        <tr>
          <td>ID</td>
          <td>Fecha</td>
          <td>Cliente</td>
          <td>Cantidad</td>
          <td>Producto</td>
          <td>Precio</td>
          <td>Factura</td>
          <td>Ejecutivo</td>

        </tr>
      </thead>
      <tbody>      
        @foreach ($salidasAlmacen as $op)
          @if ($op->total-$op->abono > 0)
          <tr>
            <td>{{$op->id}}</td>
            <td>{{date("d/m/Y h:i:s", strtotime($op->created_at))}}</td>
            <td>
              {{$op->cliente->nombre??''}}
              @if ($op->saldo_favor)
              ({{number_format($op->saldo_favor,2,'.',',')}} <a href="{{route('contabilidad.editar_recibos',$op->id_saldo)}}" target="_blank" title="Editar recibo"><i class="fas fa-search-plus"></i></a>)      
              @endif
            </td>
            <td>{{$op->cantidad??''}}</td>
            <td>{{$op->producto->nombre??''}}</td>
            <td>{{number_format($op->precio,2,'.',',')}}</td>
            <td>
              @if($op->nota)
              
                @if ($op->nota->id_tipo==1)
                  {{number_format(($op->total - $op->nota->cantidad),2,'.',',')}}
                @else
                  {{number_format(($op->total + $op->nota->cantidad),2,'.',',')}}
                @endif
              @else
                  {{number_format($op->total,2,'.',',')}}
              @endif
              
            </td>
            <td>
                {{ $op->cliente->info_ejecutivo->name ?? ''}}
            </td>
          </tr>
          @endif
        @endforeach
      </tbody>
    </table>
  </form>
  </div>
</div>
<div class="modal fade" id="entregaInventario" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">NOTA DE DÉBITO/CRÉDITO</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="form-group">
          <label for="inputState">TIPO</label>
          <select id="tipo_debito" name="tipo_debito" class="form-control">
            <option value="1">NOTA DE DEBITO</option>
            <option value="2">NOTA DE CREDITO</option>
          </select>
        </div>
        <div class="form-group">
            <label for="recipient-name" class="col-form-label">Valor:</label>
            <input type="number" class="form-control" id="cantidad2" name="cantidad">
            <input type="hidden" class="form-control" id="id_factura" name="id_factura">
        </div>
        <div class="form-group">
            <label for="message-text" class="col-form-label">Observaciones:</label>
            <textarea id="observaciones2" class="form-control" id="message-text"></textarea>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" id="btnTerminarOrdenInventario" class="btn btn-primary">GUARDAR</button>
      </div>
    </div>
  </div>
</div>
<script>
   
  $(document).ready(function () {
    $('#exampleReporte').dataTable({ 
      order: [[0, 'desc']],
      paginate: false,
      dom: 'Bfrtip',
        buttons: [
            'copy','excel', 'pdf', 'print'
        ]
    });
  });

</script>
@endsection
