@extends('layouts.app')

@section('content')
@extends('contabilidad.menu')
<form action="{{ route('contabilidad.guardar_factura') }}" method="POST" enctype="multipart/form-data">
  @csrf
  <input type="hidden" name='id_cotizacion_padre' value='{{$cotizacion->id}}'>
<div id="contenedor_interno" class="container-fluid">
    <div class="row ">
      <div class="col-md-12">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('contabilidad.dashboard') }}">Factura</a></li>
            <li class="breadcrumb-item active" aria-current="page">Nueva</li>
          </ol>
        </nav>
        
          <input type="submit" href="{{route('ventas.cliente')}}" class="botonColor" value="Guardar Factura" />
      </div>
      <hr>
    </div>
</div>

<div id="contenedor_contenido" class="container-fluid px-lg-5">
  <div class="row">
    <div class="col-md-12">
      <div class="d-flex align-items-center align-middle">
        <h2>Factura</h2>
        <h2 class="ml-4">No. {{$idSalida}}</h2>
      </div>
    </div>
    @if($cotizacion->estatus==99)
    <div class="alert alert-danger col-md-12" role="alert">
      {{$cotizacion->comentario_ing}}
    </div>
    @endif
    <div class="col-md-12">
        <div class="row">
          <div class="col-md-6">
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Cliente</label>
              <div class="col-sm-8">
                  <p>{{$cotizacion->cliente->nombre}}</p>
                  <input type="hidden" name="id_cliente" value="{{$cotizacion->id_cliente}}">
                  <input type="hidden" name="id_producto" value="{{$cotizacion->id_producto}}">
                  <input type="hidden" name="cantidad" value="{{$cotizacion->cantidad}}">
                  <input type="hidden" name="precio" value="{{$cotizacion->producto->precio_venta}}">
                  <input type="hidden" name="id_salida" value="{{$cotizacion->id}}">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Nit</label>
              <div class="col-sm-8">
                <input type="text" readonly class="form-control-plaintext" id="nit" value="{{ $cotizacion->cliente->nit }}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Dirección</label>
              <div class="col-sm-8">
                <p>{{ $cotizacion->cliente->direccion }}</p>
              </div>
            </div>
          </div>


          <div class="col-md-6">
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Moneda</label>
              <div class="col-sm-8">
                <select class="form-control" name="id_moneda" id="exampleFormControlSelect1">
                  <option {{ $cotizacion->cliente->id_moneda == 1 ? "selected" : "" }} value="1">Q</option>
                  <option {{ $cotizacion->cliente->id_moneda == 2 ? "selected" : "" }} value="2">$</option>
                </select>
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Condiciones de pago</label>
              <div class="col-sm-8">
                @if ($cotizacion->cliente->condiciones_pago == 1)
                  <p>Contado</p>
                @endif
                @if ($cotizacion->cliente->condiciones_pago == 6)
                  <p>8 días</p>
                @endif
                @if ($cotizacion->cliente->condiciones_pago == 2)
                  <p>15 días</p>
                @endif
                @if ($cotizacion->cliente->condiciones_pago == 3)
                  <p>30 días</p>
                @endif
                @if ($cotizacion->cliente->condiciones_pago == 4)
                  <p>45 días</p>
                @endif
                @if ($cotizacion->cliente->condiciones_pago == 5)
                  <p>60 días</p>
                @endif
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Régimen fiscal
              </label>
              <div class="col-sm-8">
                @if ($cotizacion->cliente->tipo_regimen == 1)
                <p>Ninguno</p>
                @endif
                @if ($cotizacion->cliente->tipo_regimen == 2)
                  <p>Decreto régimen 2989</p>
                @endif
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Número Facturar SAT</label>
              <div class="col-sm-8">
                <input type="text" name="numero_factura" class="form-control-plaintext" value="" placeholder="" required>
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">PDF Factura</label>
              <div class="col-sm-8">
                <input type="file" name="pdf_factura" class="form-control-plaintext" accept="application/pdf" required>
              </div>
            </div>
          </div>
        </div>
        <!-- Productos -->
        <div class="row">
          <div class="col-md-12">
            <ul class="nav nav-tabs" id="myTab">
              <li class="nav-item">
                  <a href="#home" class="nav-link" data-toggle="tab">Lista del pedido</a>
              </li>
            </ul>
            <div class="tab-content">
              <div class="tab-pane fade" id="home">
                <table class="table">
                  <thead>
                    <tr>
                      <th scope="col">Descripción de Producto</th>
                      <th scope="col">Cantidad</th>
                      <th scope="col">Unidad de medida</th>
                      <th scope="col">Precio unitario</th>
                      <th scope="col">Impuestos</th>
                      <th scope="col">Total</th>
                      <th scope="col">Cotización</th>
                    </tr>
                  </thead>
                  <tbody id="contenedorProductos">
                    <tr class="producto"> 
                      <td>
                        <p>{{$cotizacion->producto->medida->nombre}} {{$cotizacion->producto->nombre}}</p>
                      </td>
                      <td><p>{{$cotizacion->cantidad}}</p></td>
                      <td><p>{{$cotizacion->producto->medida->nombre}}</p></td>
                      @if ($cotizacion->id_cotizacion>0)
                        <td>
                          @if ($cotizacion->cliente->tipo_regimen == 2)
                          <p>{{number_format($cotizacion->cotizacion->precio/1.12,2,'.',',')}}</p>
                          @else
                          <p>{{number_format($cotizacion->cotizacion->precio,2,'.',',')}}</p>
                          @endif
                        </td>
                        <td>
                          @if ($cotizacion->cliente->tipo_regimen == 2)
                          <p>{{number_format(((0*$cotizacion->cotizacion)*.12),2,'.',',')}}</p>
                          @else
                          <p>{{number_format(((($cotizacion->cotizacion->precio-($cotizacion->cotizacion->precio/1.12))*$cotizacion->cantidad)),2,'.',',')}}</p>
                          @endif
                        </td>
                        <td>
                          @if ($cotizacion->cliente->tipo_regimen == 2)
                          <p>{{number_format(($cotizacion->cotizacion->precio*$cotizacion->cantidad),2,'.',',')}}</p>
                          @else
                          <p>{{number_format((($cotizacion->cotizacion->precio*$cotizacion->cantidad)),2,'.',',')}}</p>
                          @endif
                        </td>
                      @else
                      <td>
                        @if ($cotizacion->cliente->tipo_regimen == 2)
                        <p>{{number_format($cotizacion->op->cotizaciones_p->precio,2,'.',',')}}</p>
                        @else
                        <p>{{number_format($cotizacion->op->cotizaciones_p->precio/1.12,2,'.',',')}}</p>
                        @endif
                        
                      </td>
                      
                      <td>
                        @if ($cotizacion->cliente->tipo_regimen == 2)
                        <p>{{number_format(((0*$cotizacion->cotizacion)*.12),2,'.',',')}}</p>
                        @else
                        <p>{{number_format(((($cotizacion->op->cotizaciones_p->precio-($cotizacion->op->cotizaciones_p->precio/1.12))*$cotizacion->cantidad)),2,'.',',')}}</p>
                        @endif
                      </td>
                      
                      <td>
                        @if ($cotizacion->cliente->tipo_regimen == 2)
                        <p>{{number_format(($cotizacion->op->cotizaciones_p->precio*$cotizacion->cantidad),2,'.',',')}}</p>
                        @else
                        <p>{{number_format(($cotizacion->op->cotizaciones_p->precio*$cotizacion->cantidad),2,'.',',')}}</p>
                        @endif
                      </td>
                      @endif
                      <td>
                        @if($cotizacion->cotizacion)
                        <a  href="{{ asset('/cotizaciones/CO_'.$cotizacion->cotizacion->id.'.pdf') }}" target='_blank'>{{$cotizacion->cotizacion->id}}<i class="far fa-file-pdf"></i></a> 
                        @endif
                        @if($cotizacion->op)
                  
                        <a  href="{{ asset('/cotizaciones/CO_'.$cotizacion->op->id_cotizacion.'.pdf') }}" target='_blank'>{{$cotizacion->op->id_cotizacion}}<i class="far fa-file-pdf"></i></a> 
                        @endif
                      </td>
                    </tr>
                  </tbody>
                </table>
                <hr>
                <div class="total">
                  @if ($cotizacion->id_cotizacion>0)
                    <p>Impuestos: Q <span id="impuestos">
                      @if ($cotizacion->cliente->tipo_regimen == 2)
                        {{number_format(((0*$cotizacion->cantidad)*.12),2,'.',',')}}
                      @else
                      {{number_format(((($cotizacion->cotizacion->precio-($cotizacion->cotizacion->precio/1.12))*$cotizacion->cantidad)),2,'.',',')}}
                      @endif
                    </span>
                    </p>
                    <p class="mostrarTotal">Total: Q <span id="totalTotal">
                      @if ($cotizacion->cliente->tipo_regimen == 2)
                      <input type="hidden" name="total" value="{{($cotizacion->cotizacion->precio*$cotizacion->cantidad)}}">
                      {{number_format(($cotizacion->cotizacion->precio*$cotizacion->cantidad),2,'.',',')}}
                    @else
                    <input type="hidden" name="total" value="{{(($cotizacion->cotizacion->precio*$cotizacion->cantidad))}}">
                      {{number_format((($cotizacion->cotizacion->precio*$cotizacion->cantidad)),2,'.',',')}}
                    @endif
                    </span></p>
                  @else
                      <p>Impuestos: Q <span id="impuestos">
                        @if ($cotizacion->cliente->tipo_regimen == 2)
                          {{number_format(((0*$cotizacion->cantidad)*.12),2,'.',',')}}
                        @else
                        {{number_format(((($cotizacion->op->cotizaciones_p->precio-($cotizacion->op->cotizaciones_p->precio/1.12))*$cotizacion->cantidad)),2,'.',',')}}
                        @endif
                      </span>
                      </p>
                      <p class="mostrarTotal">Total: Q <span id="totalTotal">
                        @if ($cotizacion->cliente->tipo_regimen == 2)
                        <input type="hidden" name="total" value="{{($cotizacion->op->cotizaciones_p->precio*$cotizacion->cantidad)}}">
                        {{number_format(($cotizacion->op->cotizaciones_p->precio*$cotizacion->cantidad),2,'.',',')}}
                      @else
                      <input type="hidden" name="total" value="{{(($cotizacion->op->cotizaciones_p->precio*$cotizacion->cantidad))}}">
                        {{number_format((($cotizacion->op->cotizaciones_p->precio*$cotizacion->cantidad)),2,'.',',')}}
                      @endif
                      </span></p>
                  @endif
                  
                </div>
                
              </div>
              <div class="tab-pane fade" id="profile">
                <div class="row">
                  <div class="col-md-12">
                    <br>
                    <h4>Información de envio</h4>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Almacén</label>
                      <div class="col-sm-8">
                        <input type="text" readonly class="form-control-plaintext" value="" placeholder="">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Política de entrega	</label>
                      <div class="col-sm-8">
                        <input type="text" readonly class="form-control-plaintext" value="" placeholder="">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Fecha de pedido	</label>
                      <div class="col-sm-8">
                        <input type="text" readonly class="form-control-plaintext" value="" placeholder="">
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Usuario</label>
                      <div class="col-sm-8">
                        <input type="text" readonly class="form-control-plaintext" value="" placeholder="">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Equipo de ventas</label>
                      <div class="col-sm-8">
                        <input type="text" readonly class="form-control-plaintext" value="" placeholder="">
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="" class="col-sm-4 col-form-label">Referencia cliente</label>
                      <div class="col-sm-8">
                        <input type="text" readonly class="form-control-plaintext" value="" placeholder="">
                      </div>
                    </div>
                  </div>
                </div>
              </div>

            </div>
        </div>
      

    </div>
  </div>
</div>
</form>
<script>
  function nuevaFila(){
    var row = document.getElementsByClassName("producto"); // find row to copy
    var table = document.getElementById("contenedorProductos"); // find table to append to
    var clone = row[0].cloneNode(true); // copy children too
    table.appendChild(clone); // add new row to end of table
    clone.getElementsByClassName('precio_sugerido')[0].value='';
    clone.getElementsByClassName('cantidad')[0].value='';
    clone.getElementsByClassName('unidad_medida')[0].value='';
    clone.getElementsByClassName('idMedida')[0].value=0;
    clone.getElementsByClassName('impuestos')[0].value='';
    clone.getElementsByClassName('subTotal')[0].value='';
  }
  function infoCliente(elemento){
    jQuery( document ).ready(function() {
      var token = '{{ csrf_token() }}';
      $.ajax({
        type:'POST',
        url:'{{ route('ventas.buscar_cliente') }}',
        headers: {'X-CSRF-TOKEN': token},
        data:{
          id_cliente:elemento.value,
        },
        success:function(data){
          $('#nit').val(data.nit);
          $('#direccion').val(data.direccion);
          $('#direccion').val(data.direccion);
          console.log('hola',data.condiciones_pago);
          $("#condiciones_pago").val(data.condiciones_pago).change();
        }
      });
    });
  }
  function calcularSubTotal(elemento){
    var padre=elemento.parentElement.parentElement;
    var precio=padre.getElementsByClassName('precio_sugerido')[0].value;
    var cantidad=padre.getElementsByClassName('cantidad')[0].value;
    var subTotal=precio*cantidad;
    var impuestos=subTotal*0.12;
    var totalImpuesto=0;
    var totalTotal=0;
    padre.getElementsByClassName('impuestos')[0].value='Q '+impuestos.toFixed( 2 ).replace(/\d(?=(\d{3})+\.)/g, '$&,');
    var subTotal=impuestos+subTotal;
    padre.getElementsByClassName('subTotal')[0].value='Q '+subTotal.toFixed( 2 ).replace(/\d(?=(\d{3})+\.)/g, '$&,');
    //Sumar impuestos
    console.log(document.querySelectorAll('impuestos'));
    document.querySelectorAll('.impuestos').forEach(element => {
      var purgar_impuesto=element.value.replace(',', '').replace('Q', '');
      totalImpuesto=parseFloat(totalImpuesto)+parseFloat(purgar_impuesto);
    });
    document.getElementById('impuestos').innerHTML=totalImpuesto.toFixed( 2 ).replace(/\d(?=(\d{3})+\.)/g, '$&,');

    document.querySelectorAll('.subTotal').forEach(element => {
      
      var purgar_total=element.value.replace(',', '').replace('Q', '');
      console.log(purgar_total);
      totalTotal=parseFloat(totalTotal)+parseFloat(purgar_total);
    });
    document.getElementById('totalTotal').innerHTML=totalTotal.toFixed( 2 ).replace(/\d(?=(\d{3})+\.)/g, '$&,');
  }
  function infoProducto(elemento){
    jQuery( document ).ready(function() {
      var token = '{{ csrf_token() }}';
      $.ajax({
        type:'POST',
        url:'{{ route('ventas.buscar_producto') }}',
        headers: {'X-CSRF-TOKEN': token},
        data:{
          id_producto:elemento.value,
        },
        success:function(data){
          var padre=elemento.parentElement.parentElement;
          padre.getElementsByClassName('precio_sugerido')[0].value='';
          padre.getElementsByClassName('cantidad')[0].value='';
          padre.getElementsByClassName('unidad_medida')[0].value='';
          padre.getElementsByClassName('idMedida')[0].value=0;
          padre.getElementsByClassName('impuestos')[0].value='';
          padre.getElementsByClassName('subTotal')[0].value='';
          $(padre).find('.unidad_medida').val(data.medida.nombre);
          $(padre).find('.idMedida').val(data.medida.id);
          $(padre).find('.precio_sugerido').val(data.precio_venta);
        }
      });
    });
  }

</script>
@endsection
