<?php

namespace App\Http\Controllers;

use App\Ajustes;
use App\ProductoCategorias;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class AjustesController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $tipo_cambio = Ajustes::where('nombre_campo', 'tipo_cambio')->first();

        $categoriasProductos = ProductoCategorias::with('detalleCategoriaProducto')
            ->where('calculo_precio', 1)
            ->get();

        return view('ajustes.dashboard', compact('tipo_cambio', 'categoriasProductos'));
    }


    public function storeOrUpdate(Request $request)
    {
        // dd($request->all());
        DB::beginTransaction();
        try {
            $data = $request->validate([
                'id' => 'nullable|integer',
                'nombre' => 'required|string|max:255',
                'factor' => 'required|numeric',
                'factor_costo_venta' => 'required|numeric',
                'porcentaje_desperdicio' => 'required|numeric',
                'capas' => 'required|integer',
                'calibres' => 'nullable|array',
                'calibres.*.nombre' => 'required|string|max:255',
                'calibres.*.valor' => 'required|numeric',
            ]);

            // Agregar campos faltantes calculo_precio = 1 y tipo = 2
            $data['calculo_precio'] = 1;
            $data['tipo'] = 2;

            if ($request->id) {
                $categoria = ProductoCategorias::findOrFail($request->id);
                $categoria->update($data);
            } else {
                $categoria = ProductoCategorias::create($data);
            }

            // Sincronizar calibres
            $calibresData = [];
            if (!empty($data['calibres'])) {
                foreach ($data['calibres'] as $calibre) {
                    $calibresData[] = [
                        'nombre' => $calibre['nombre'],
                        'valor' => $calibre['valor']
                    ];
                }
            }
            $categoria->detalleCategoriaProducto()->delete();
            $categoria->detalleCategoriaProducto()->createMany($calibresData);

            DB::commit();

            return redirect()->route('ajustes.dashboard')->with('success', 'Categoría guardada correctamente.');
        } catch (\Throwable $th) {
            DB::rollBack();
            echo $th->getMessage();
        }
    }

    public function guardarAjustes(Request $request)
    {
        //
        $ajuste = Ajustes::where('nombre_campo', 'tipo_cambio')->first();
        $ajuste->valor = $request->tipo_cambio;
        $ajuste->update();
        $arrResponse = [
            'message' => 'Ajuste guardado correctamente'
        ];
        return redirect()->route('ajustes.dashboard')->with($arrResponse);
    }
}
