<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Helpers\Moneda;

class Compra extends Model
{
    use SoftDeletes;
    protected $fillable = [
        'correlativo',
        'total_pi',
        'total_factura',
        'observaciones',
        'condiciones',
        'condiciones_pago',
        'direccion',
        'proforma_documento',
        'tipo_cambio',
        'tipo_compra',
        'proveedor_id',
        'moneda_id',
    ];

    public function proveedor()
    {
        return $this->belongsTo(Proveedor::class);
    }

    public function detalle()
    {
        return $this->hasMany(CompraProducto::class);
    }

    public function pagos()
    {
        return $this->hasMany(CompraPago::class)->orderBy('created_at', 'desc');
    }

    public function envio()
    {
        return $this->hasMany(CompraEnvio::class)->orderBy('created_at', 'desc');
    }

    public function getProformaDocumentoUrlAttribute()
    {
        return $this->proforma_documento ? asset('storage/compras/locales/' . $this->proforma_documento) : null;
    }



    /**
     * Obtiene el nombre de la moneda para la compra
     * @return string|null
     */
    public function getMonedaNombreAttribute()
    {
        return Moneda::getNombre($this->moneda_id);
    }

    /**
     * Obtiene el símbolo de la moneda para la compra
     * @return string|null
     */
    public function getMonedaSimboloAttribute()
    {
        return Moneda::getSimbolo($this->moneda_id);
    }

    /**
     * Obtiene el tipo de cambio global
     * @return float|null
     */
    public function getTipoCambioGlobalAttribute()
    {
        return Moneda::getTipoCambioGlobal();
    }
}
